class MassaccreGameRules extends GameRules;

var array< class<Inventory> > BonusCapInventory;

function ScoreKill( Controller Killer, Controller Killed )
{
    local Controller C;
	local UTPawn KillerPawn;
	local UTPlayerReplicationInfo KillerPRI, KilledPRI;
	local bool bFirstBonus;
    local bool bEnemyKill;

	if ( Killer != None )
		KillerPRI = UTPlayerReplicationInfo(Killer.PlayerReplicationInfo);
	if ( Killed != None )
		KilledPRI = UTPlayerReplicationInfo(Killed.PlayerReplicationInfo);

	bEnemyKill = ( ((KillerPRI != None) && (KillerPRI != KilledPRI) && (KilledPRI != None)) && (!WorldInfo.GRI.GameClass.Default.bTeamGame || (KillerPRI.Team != KilledPRI.Team)) );

    KillerPawn = UTPawn(Killer.Pawn);

    if ( UTPlayerController(Killer) != None && KillerPRI.MultiKillLevel == 1 && KillerPawn.FindInventoryType(class'MultiKillActivator') == none && KillerPawn.FindInventoryType(class'MultiKillActivatora') == none && KillerPawn.FindInventoryType(class'MultiKillActivatorb') == none && KillerPawn.FindInventoryType(class'MultiKillActivatorc') == none && KillerPawn.FindInventoryType(class'MultiKillActivatord') == none && KillerPawn.FindInventoryType(class'MultiKillActivatore') == none && KillerPawn.FindInventoryType(class'MultiKillDeactivator') == none )
	{
         KillerPawn.DamageScaling +=(KillerPawn.DamageScaling * 0.10);
		 KillerPawn.ReceiveLocalizedMessage(class'RushBonusMessage', 0, KillerPawn.PlayerReplicationInfo, None, None);
         KillerPawn.CreateInventory(BonusCapInventory[0]);
	}

    if ( UTPlayerController(Killer) != None && KillerPRI.MultiKillLevel == 2 && KillerPawn.FindInventoryType(class'MultiKillActivatora') == none && KillerPawn.FindInventoryType(class'MultiKillActivatorb') == none && KillerPawn.FindInventoryType(class'MultiKillActivatorc') == none && KillerPawn.FindInventoryType(class'MultiKillActivatord') == none && KillerPawn.FindInventoryType(class'MultiKillActivatore') == none && KillerPawn.FindInventoryType(class'MultiKillDeactivator') == none )
	{
		 KillerPawn.DamageScaling += (KillerPawn.DamageScaling * 0.15);
		 KillerPawn.AirSpeed += (KillerPawn.AirSpeed * 0.15);
		 KillerPawn.GroundSpeed += (KillerPawn.GroundSpeed * 0.15);
		 KillerPawn.WaterSpeed += (KillerPawn.WaterSpeed * 0.15);
		 KillerPawn.ReceiveLocalizedMessage(class'RushBonusMessage', 1, KillerPawn.PlayerReplicationInfo, None, None);
		 KillerPawn.CreateInventory(BonusCapInventory[1]);
	}

    if ( UTPlayerController(Killer) != None && KillerPRI.MultiKillLevel == 3 && KillerPawn.FindInventoryType(class'MultiKillActivatorb') == none && KillerPawn.FindInventoryType(class'MultiKillActivatorc') == none && KillerPawn.FindInventoryType(class'MultiKillActivatord') == none && KillerPawn.FindInventoryType(class'MultiKillActivatore') == none && KillerPawn.FindInventoryType(class'MultiKillDeactivator') == none )
	{
		 KillerPawn.DamageScaling += (KillerPawn.DamageScaling * 0.15);
		 KillerPawn.AccelRate += (KillerPawn.AccelRate * 0.15);
		 KillerPawn.ReceiveLocalizedMessage(class'RushBonusMessage', 2, KillerPawn.PlayerReplicationInfo, None, None);
		 KillerPawn.CreateInventory(BonusCapInventory[2]);
	}

    if ( UTPlayerController(Killer) != None && KillerPRI.MultiKillLevel == 4 && KillerPawn.FindInventoryType(class'MultiKillActivatorc') == none && KillerPawn.FindInventoryType(class'MultiKillActivatord') == none && KillerPawn.FindInventoryType(class'MultiKillActivatore') == none && KillerPawn.FindInventoryType(class'MultiKillDeactivator') == none )
	{
	     KillerPawn.DamageScaling += (KillerPawn.DamageScaling * 0.2);
	     KillerPawn.DodgeSpeed += (KillerPawn.DodgeSpeed * 0.2);
	     KillerPawn.DodgeSpeedZ += (KillerPawn.DodgeSpeedZ * 0.2);
     	 KillerPawn.AirControl += (KillerPawn.AirControl * 0.2);
     	 KillerPawn.JumpZ += (KillerPawn.JumpZ * 0.2);
         KillerPawn.ReceiveLocalizedMessage(class'RushBonusMessage', 3, KillerPawn.PlayerReplicationInfo, None, None);
         KillerPawn.CreateInventory(BonusCapInventory[3]);
   	}

    if ( UTPlayerController(Killer) != None && KillerPRI.MultiKillLevel == 5 && KillerPawn.FindInventoryType(class'MultiKillActivatord') == none && KillerPawn.FindInventoryType(class'MultiKillActivatore') == none && KillerPawn.FindInventoryType(class'MultiKillDeactivator') == none )
    {
     	 KillerPawn.DamageScaling += (KillerPawn.DamageScaling * 0.25);
		 KillerPawn.HelmetArmor += (KillerPawn.HelmetArmor * 0.25);
     	 KillerPawn.ShieldBeltArmor += (KillerPawn.ShieldBeltArmor * 0.25);
     	 KillerPawn.ThighpadArmor += (KillerPawn.ThighpadArmor * 0.25);
     	 KillerPawn.VestArmor += (KillerPawn.VestArmor * 0.25);
     	 KillerPawn.ReceiveLocalizedMessage(class'RushBonusMessage', 4, KillerPawn.PlayerReplicationInfo, None, None);
     	 KillerPawn.CreateInventory(BonusCapInventory[4]);
    }

    //////////////////////////////////////////////////////////////////////////////
    //This two Bonuses were for Ludacris and Holyshit bonuses that were in      //
    //UT2004. since those two are not given in anymore, they have been disabled //
    //I will not remove the code because I'm thinking about bringing back those //
    //two bonuses for my Soul's Fury mod.                                       //
    //////////////////////////////////////////////////////////////////////////////
    /*if ( UTPlayerController(Killer) != None && KillerPRI.MultiKillLevel == 6 && KillerPawn.FindInventoryType(class'MultiKillActivatore') == none && KillerPawn.FindInventoryType(class'MultiKillDeactivator') == none )
    {
     	 KillerPawn.DamageScaling += (KillerPawn.DamageScaling * 0.20);
     	 KillerPawn.ShieldBeltArmor += (KillerPawn.ShieldBeltArmor * 0.2);
     	 KillerPawn.ThighpadArmor += (KillerPawn.ThighpadArmor * 0.2);
     	 KillerPawn.VestArmor += (KillerPawn.VestArmor * 0.2);
     	 KillerPawn.ReceiveLocalizedMessage(class'RushBonusMessage', 5, KillerPawn.PlayerReplicationInfo, None, None);
     	 KillerPawn.CreateInventory(BonusCapInventory[5]);
    }

    if ( UTPlayerController(Killer) != None && KillerPRI.MultiKillLevel == 7 && KillerPawn.FindInventoryType(class'MultiKillDeactivator') == none )
    {

		 KillerPawn.DamageScaling += (KillerPawn.DamageScaling * 0.3);
     	 KillerPawn.AccelRate += (KillerPawn.AccelRate * 0.3);
     	 KillerPawn.AirControl += (KillerPawn.AirControl * 0.3);
		 KillerPawn.AirSpeed += (KillerPawn.AirSpeed * 0.3);
     	 KillerPawn.JumpZ += (KillerPawn.JumpZ * 0.3);
     	 KillerPawn.GroundSpeed += (KillerPawn.GroundSpeed * 0.3);
     	 KillerPawn.DodgeSpeed += (KillerPawn.DodgeSpeed * 0.3);
     	 KillerPawn.DodgeSpeedZ += (KillerPawn.DodgeSpeedZ * 0.3);
     	 KillerPawn.WaterSpeed += (KillerPawn.WaterSpeed * 0.3);
     	 KillerPawn.ReceiveLocalizedMessage(class'FinalRushBonusMessage', 0, KillerPawn.PlayerReplicationInfo, None, None);
         KillerPawn.CreateInventory(BonusCapInventory[6]);
    }*/

    if ( UTPlayerController(Killer) != None && KillerPRI.Spree == 5 )
	{
		 KillerPawn.GroundSpeed += (KillerPawn.GroundSpeed * 0.15);
		 KillerPawn.WaterSpeed += (KillerPawn.WaterSpeed * 0.15);
		 KillerPawn.AirSpeed += (KillerPawn.AirSpeed * 0.15);
		 KillerPawn.AccelRate += (KillerPawn.AccelRate * 0.15);
		 KillerPawn.ReceiveLocalizedMessage(class'RushSpreeBonusMessage', 0, KillerPawn.PlayerReplicationInfo, None, None);
	}

	if ( UTPlayerController(Killer) != None && KillerPRI.Spree == 10 )
    {
     	 KillerPawn.DamageScaling += (KillerPawn.DamageScaling * 0.15);
     	 KillerPawn.DodgeSpeed += (KillerPawn.DodgeSpeed * 0.15);
     	 KillerPawn.DodgeSpeedZ += (KillerPawn.DodgeSpeedZ * 0.15);
     	 KillerPawn.AirControl += (KillerPawn.AirControl * 0.15);
		 KillerPawn.JumpZ += (KillerPawn.JumpZ * 0.15);
     	 KillerPawn.ReceiveLocalizedMessage(class'RushSpreeBonusMessage', 1, KillerPawn.PlayerReplicationInfo, None, None);
    }

    if ( UTPlayerController(Killer) != None && KillerPRI.Spree == 15 )
    {
         if ( KillerPawn.SuperHealthMax >= 1)
	     {
              KillerPawn.SuperHealthMax += (KillerPawn.SuperHealthMax * 0.50);
		      KillerPawn.ReceiveLocalizedMessage(class'RushSpreeBonusMessage', 2, KillerPawn.PlayerReplicationInfo, None, None);
	     }

         //This is for when I set back up the species mutator and the non-living species
         /*if ( KillerPawn.SuperHealthMax <= 0 )
	     {
		      KillerPawn.Health += (KillerPawn.Health * 0.45);
		      KillerPawn.ReceiveLocalizedMessage(class'RushSpreeBonusMessage', 6, KillerPawn.PlayerReplicationInfo, None, None);
	     }*/
    }

	if ( UTPlayerController(Killer) != None && KillerPRI.Spree == 20 )
	{
         if ( KillerPawn.SuperHealthMax >= 1 )
	     {
		      KillerPawn.HealthMax += (KillerPawn.HealthMax * 0.50);
		      KillerPawn.ReceiveLocalizedMessage(class'RushSpreeBonusMessage', 3, KillerPawn.PlayerReplicationInfo, None, None);
	     }

         //This is for when I set back up the species mutator and the non-living species
         /*if ( KillerPawn.SuperHealthMax <= 0 )
	     {
		      KillerPawn.Health += (KillerPawn.Health * 0.90);
		      KillerPawn.ReceiveLocalizedMessage(class'RushSpreeBonusMessage', 7, KillerPawn.PlayerReplicationInfo, None, None);
	     }*/
    }

	if ( UTPlayerController(Killer) != None && KillerPRI.Spree == 25 )
	{
		 KillerPawn.HelmetArmor += (KillerPawn.HelmetArmor * 0.3);
     	 KillerPawn.ShieldBeltArmor += (KillerPawn.ShieldBeltArmor * 0.3);
     	 KillerPawn.ThighpadArmor += (KillerPawn.ThighpadArmor * 0.3);
     	 KillerPawn.VestArmor += (KillerPawn.VestArmor * 0.3);
		 KillerPawn.ReceiveLocalizedMessage(class'RushSpreeBonusMessage', 4, KillerPawn.PlayerReplicationInfo, None, None);
	}

	if ( UTPlayerController(Killer) != None && KillerPRI.Spree == 30 )
	{
		 KillerPawn.DamageScaling += (KillerPawn.DamageScaling * 0.25);
		 KillerPawn.AccelRate += (KillerPawn.AccelRate * 0.25);
		 KillerPawn.AirControl += (KillerPawn.AirControl * 0.25);
		 KillerPawn.AirSpeed += (KillerPawn.AirSpeed * 0.25);
		 KillerPawn.JumpZ += (KillerPawn.JumpZ * 0.25);
		 KillerPawn.GroundSpeed += (KillerPawn.GroundSpeed * 0.25);
		 KillerPawn.DodgeSpeed += (KillerPawn.DodgeSpeed * 0.25);
		 KillerPawn.DodgeSpeedZ += (KillerPawn.DodgeSpeedZ * 0.25);
		 KillerPawn.WaterSpeed += (KillerPawn.WaterSpeed * 0.25);
		 KillerPawn.ReceiveLocalizedMessage(class'RushSpreeBonusMessage', 5, KillerPawn.PlayerReplicationInfo, None, None);

	}

    if ( KillerPRI.Kills == 1 && bEnemyKill )
	{
         foreach WorldInfo.AllControllers( class'Controller', C )
         {
              if ( C.PlayerReplicationInfo != None && C.bIsPlayer && C.PlayerReplicationInfo != KillerPRI && C.PlayerReplicationInfo.Kills >= 1)
			  {
			       bFirstBonus = True;
              }
   	     }

   	     if ( !bFirstBonus )
   	     {
              KillerPawn.DamageScaling +=(KillerPawn.DamageScaling * 0.45);
		      KillerPawn.ReceiveLocalizedMessage(class'RushSpecialBonusMessage', 0, KillerPawn.PlayerReplicationInfo, None, None);
         }
    }
}

defaultproperties
{
   BonusCapInventory(0)=Class'Massaccre.MultiKillActivator'
   BonusCapInventory(1)=Class'Massaccre.MultiKillActivatora'
   BonusCapInventory(2)=Class'Massaccre.MultiKillActivatorb'
   BonusCapInventory(3)=Class'Massaccre.MultiKillActivatorc'
   BonusCapInventory(4)=Class'Massaccre.MultiKillActivatord'
   BonusCapInventory(5)=Class'Massaccre.MultiKillActivatore'
   BonusCapInventory(6)=Class'Massaccre.MultiKillDeactivator'
}
